
const sampler_t sampler = CLK_NORMALIZED_COORDS_TRUE | CLK_ADDRESS_CLAMP_TO_EDGE | CLK_FILTER_LINEAR;
#define vec2 float2
#define vec3 float3
#define vec4 float4

vec4 INPUTSRC(image2d_t src_data,__global FilterParam* param, vec2 tc)
{
	tc = (vec2)(tc.x, tc.y)*(vec2)(param->origROI[2], param->origROI[3]) + (vec2)(param->origROI[0], param->origROI[1]);
	return read_imagef(src_data, sampler, tc);
}

vec4 INPUT(image2d_t src_data, vec2 tc)
{
	return read_imagef(src_data, sampler, tc);
}

__kernel void MAIN(__read_only image2d_t input1,__read_only image2d_t input2,
					__write_only image2d_t dstImg,__global FilterParam* param, int alpha)
{
	int W = get_global_size(0);
	int H = get_global_size(1);
	int textH = param->height[0];;
	float iGlobalTime = param->cur_time / param->total_time;
	
	float progress = 0.5;
	int w = get_global_id(0);
	int h = get_global_id(1);
	float2 resolution = (float2)(W,H);
	int2 gl_FragCoord = (int2)(get_global_id(0), get_global_id(1));
	vec2 fragCoord = (vec2)(get_global_id0( param), get_global_id1( param));
	vec2 tc = ((vec2)(fragCoord.x, fragCoord.y) + (vec2)(0.5f))/resolution.xy;
	
	 vec4 orig = INPUTSRC(input1, param, tc);
	 vec3 texel = orig.xyz;
     
     texel = (vec3)(
                  INPUT(input2,(vec2)(texel.z, .16666f)).z,
                  INPUT(input2,(vec2)(texel.y, .5f)).y,
                  INPUT(input2,(vec2)(texel.x, .83333f)).x);
				  
     write_imagef(dstImg, (int2)(w, h), mix((vec4)(texel.zyx, orig.w), orig, 1.0f - alpha/100.0f));
}